<?xml version="1.0" encoding="utf-8"?>
<!--
  jlcc.xsl
  Written by Masaya YAMAGUCHI
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- 表示用 -->

  <xsl:template match="jlcc">
    <html xmlns:xhtml="http://www.w3.org/1999/xhtml" lang="ja">
      <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta http-equiv="Content-Style-Type" content="text/css" />
        <link rel="stylesheet" href="jlcc.css" type="text/css" />
	<title>
		<xsl:value-of select="@id"/>
		<xsl:text>：</xsl:text>
		<xsl:value-of select="@theme"/>
	</title>
      </head>

      <body>
        <h1>
	  <xsl:value-of select="@id"/>
	  <xsl:text>：</xsl:text>
	  <xsl:value-of select="@theme"/>
        </h1>
	<hr />
	<ul>
	  <li>学習者のID：<xsl:value-of select="@id" /></li>
	  <li>性別：<xsl:value-of select="@sex" /></li>
	  <li>学習環境：<xsl:value-of select="@env" /></li>
	  <li>学習者の母語：<xsl:value-of select="@native" /></li>
	  <li>日本語学習履歴：<xsl:value-of select="@history" /></li>
	  <li>日本語レベル：<xsl:value-of select="@level" /></li>
	  <li>テスト成績（文字語彙）：<xsl:value-of select="@chr_grade" /></li>
	  <li>テスト成績（文法）：<xsl:value-of select="@grammar_grade" /></li>
	</ul>
	<img class="handwriting">
	  <xsl:attribute name="src">
	    <xsl:value-of select="img/@src"/>
	  </xsl:attribute>
	</img>
	<hr style="clear: both;" />
        <xsl:apply-templates/>
	<!-- reffer to http://www.feedthebot.com/pagespeed/defer-loading-javascript.html -->
	<script type="text/javascript">
	  function downloadJSAtOnload() {location.href="#himawari";}
	  if (window.addEventListener)
	  window.addEventListener("load", downloadJSAtOnload, false);
	  else if (window.attachEvent)
	  window.attachEvent("onload", downloadJSAtOnload);
	  else window.onload = downloadJSAtOnload;
	</script>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="s">
    <p>
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="w[@p!='']">
    <span class="su">
      <xsl:attribute name="title">
	<xsl:if test="@p">
	  <xsl:text>品詞: </xsl:text>
  	  <xsl:value-of select="@p"/>
	  <xsl:text>&#10;</xsl:text>
	</xsl:if>
	<xsl:if test="@c != ''">
	  <xsl:text>活用型: </xsl:text>
  	  <xsl:value-of select="@c"/>
	  <xsl:text>&#10;</xsl:text>
	</xsl:if>
	<xsl:if test="@f != ''">
	  <xsl:text>活用形: </xsl:text>
  	  <xsl:value-of select="@f"/>
	  <xsl:text>&#10;</xsl:text>
	</xsl:if>
	<xsl:if test="@l != ''">
	  <xsl:text>語彙素: </xsl:text>
  	  <xsl:value-of select="@l"/>
	  <xsl:text>&#10;</xsl:text>
	</xsl:if>
	<xsl:if test="@h != ''">
	  <xsl:text>発音: </xsl:text>
  	  <xsl:value-of select="@h"/>
	</xsl:if>
	<xsl:if test="@n != ''">
	  <xsl:text>発音: </xsl:text>
  	  <xsl:value-of select="@h"/>
	</xsl:if>
      </xsl:attribute>


      <xsl:choose>
	<xsl:when test="@n != ''">
	  <ruby class="correction">
            <rb><xsl:apply-templates/></rb>
	    <rp><xsl:text>(</xsl:text></rp>
            <rt><xsl:value-of select="@n"/></rt>
	    <rp><xsl:text>)</xsl:text></rp>
	  </ruby>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:apply-templates/>
	</xsl:otherwise>
      </xsl:choose>
    </span>
    <xsl:text>/</xsl:text>
  </xsl:template>


  <xsl:template match="tg">
    <span class="target_char">
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </span>
  </xsl:template>

</xsl:stylesheet>
